package w83b.w83bManager;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.lang.StringUtils;

import w83b.w83bBeans.W83bActasBean;
import w83b.w83bBeans.W83bCentroTrabajoBean;
import w83b.w83bBeans.W83bColegiosBean;
import w83b.w83bBeans.W83bConveniosBean;
import w83b.w83bBeans.W83bDatosEscrutiniosBean;
import w83b.w83bBeans.W83bDocBean;
import w83b.w83bBeans.W83bImpugnacionBean;
import w83b.w83bBeans.W83bIncidenciasBean;
import w83b.w83bBeans.W83bListaDelegadosBean;
import w83b.w83bBeans.W83bListaDiferenciasBean;
import w83b.w83bBeans.W83bListaEscrutiniosBean;
import w83b.w83bBeans.W83bPapeletasBean;
import w83b.w83bBeans.W83bUsuarioXLNetsBean;
import w83b.w83bDAO.W83bFactoriaDAO;
import w83b.w83bDAO.w83bConstantesBD.W83bActasBD;
import w83b.w83bDAO.w83bConstantesBD.W83bCentroTrabajoBD;
import w83b.w83bDAO.w83bConstantesBD.W83bColegiosBD;
import w83b.w83bDAO.w83bConstantesBD.W83bIncidenciasBD;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import w83b.w83bUtilidadesComunes.W83bClsTrazas;
import w83b.w83bUtilidadesComunes.W83bDateUtil;

public class W83bActas implements W83bIActas {
	public java.util.List buscarActas(w83b.w83bBeans.W83bActasBean param) throws Exception{
		
		List listaActas = W83bFactoriaDAO.getActasDAO().buscarActas(param,false);
		W83bActasBean bean; 
		HashMap municipios=new HashMap();
		String municipio="";
		//long tiempo=System.currentTimeMillis();
		for(int i=0,size=listaActas.size();i<size;i++){
			bean = (W83bActasBean)listaActas.get(i);
			if (municipios.get(bean.getCentroTrabajo().getCodTerritorio()+"|"+bean.getCentroTrabajo().getCodMunicipio())!=null){
				bean.getCentroTrabajo().setMunicipio((String)municipios.get(bean.getCentroTrabajo().getCodTerritorio()+"|"+bean.getCentroTrabajo().getCodMunicipio()));
			}
			else{
				municipio=W83bFactoriaDAO.getActasDAO().obtenerMunicipio(bean.getCentroTrabajo().getCodTerritorio(),bean.getCentroTrabajo().getCodMunicipio());
				municipios.put(bean.getCentroTrabajo().getCodTerritorio()+"|"+bean.getCentroTrabajo().getCodMunicipio(),municipio);
				bean.getCentroTrabajo().setMunicipio(municipio);
				
			}
			/*if (i%1000==0){
			System.out.println(i+"tamao"+size+" tiempo="+String.valueOf(System.currentTimeMillis()-tiempo)+" "+provincias+" "+municipios);
		}*/
		}
		
		return listaActas;	
	}
	public W83bActasBean buscarActaNueva(w83b.w83bBeans.W83bActasBean param) throws Exception{
		
		W83bActasBean acta=new W83bActasBean();
		acta.setDuplicada("false");
		List actas=W83bFactoriaDAO.getActasDAO().buscarActaNueva(param);
		List actasDatosCentro=W83bFactoriaDAO.getActasDAO().buscarActaNuevaDatosCentro(param);
		if(!actas.isEmpty()){
				HashMap datos=(HashMap)actas.get(0);
				acta.setDuplicada("true");
				acta.setValidada((String)datos.get(W83bActasBD.validada));
				acta.setVersion(((BigDecimal)datos.get(W83bActasBD.versionActa)).toString());
				if(null!=datos.get(W83bActasBD.numRegDefinitivo)){
					acta.setNumRegDefinitivo(((BigDecimal)datos.get(W83bActasBD.numRegDefinitivo)).toString());
				}
				if(null!=datos.get(W83bActasBD.codCentro)){
					acta.setCodCentroTrabajo(((BigDecimal)datos.get(W83bActasBD.codCentro)).toString());
				}
				if(null!=datos.get(W83bActasBD.numActa)){
					acta.setNumActa(((BigDecimal)datos.get(W83bActasBD.numActa)).toString());
				}
				if(null!=datos.get(W83bActasBD.fechaBaja)){
					acta.setFechaBaja(datos.get(W83bActasBD.fechaBaja).toString());
				}
				if(null!=datos.get(W83bActasBD.numTotalActa)){
					acta.setNumActaTotal(((BigDecimal)datos.get(W83bActasBD.numTotalActa)).toString());
				}
		}
		if(!actasDatosCentro.isEmpty()){
			HashMap datos=(HashMap)actasDatosCentro.get(0);
			if(null!=datos.get(W83bActasBD.codCentro)){
				acta.setCodCentroTrabajo(((BigDecimal)datos.get(W83bActasBD.codCentro)).toString());
			}
			
			if(null!=datos.get(W83bCentroTrabajoBD.codNifCif)){
				acta.setCodCif((datos.get(W83bCentroTrabajoBD.codNifCif)).toString());
			}
			if(null!=datos.get(W83bCentroTrabajoBD.ncentroTrab)){
				acta.getCentroTrabajo().setNumCentro((datos.get(W83bCentroTrabajoBD.ncentroTrab)).toString());
			}
			if(null!=datos.get(W83bCentroTrabajoBD.razonSocial)){
				acta.setRazonSocial(datos.get(W83bCentroTrabajoBD.razonSocial).toString());
			}
			if(null!=datos.get(W83bCentroTrabajoBD.codProvinciaCentro)){
				acta.getCentroTrabajo().setIdProvincia((String)datos.get(W83bCentroTrabajoBD.codProvinciaCentro).toString());
			}
			if(null!=datos.get(W83bCentroTrabajoBD.codMunicipioCentro)){
				acta.getCentroTrabajo().setIdMunicipio((String)datos.get(W83bCentroTrabajoBD.codMunicipioCentro).toString());
			}
			
				
		}
		
		return acta;	
	}
	public java.util.HashMap buscarEscrutinio(w83b.w83bBeans.W83bActasBean param) throws Exception{
		
		
		HashMap listaEscrutinios = W83bFactoriaDAO.getActasDAO().buscarEscrutinio(param);
		
		return listaEscrutinios;	
	}
	public java.util.HashMap buscarDiferencia(w83b.w83bBeans.W83bActasBean param) throws Exception{
		
		
		HashMap listaDiferencias = W83bFactoriaDAO.getActasDAO().buscarDiferencia(param);
		
		return listaDiferencias;
	}
	public java.util.HashMap buscarListaDelegados(w83b.w83bBeans.W83bActasBean param) throws Exception{
		
		
		HashMap listaDelegados = W83bFactoriaDAO.getActasDAO().buscarListaDelegados(param);
		
		return listaDelegados;	
	}
	public java.lang.Integer contarActas(w83b.w83bBeans.W83bActasBean param) throws Exception{
		
		return new Integer(W83bFactoriaDAO.getActasDAO().buscarActas(param,true).get(0).toString());	
	}
	
	public java.util.HashMap buscarCambioEscrutinio(w83b.w83bBeans.W83bActasBean param) throws Exception{
		HashMap resultados=new HashMap();
		W83bDatosEscrutiniosBean escrutinio= new W83bDatosEscrutiniosBean();
		int trabajadoresTotales=Integer.parseInt(param.getTrabajadoresTotal());
		if(trabajadoresTotales>1001){
			param.setTrabajadoresTotal("1000");
			escrutinio= W83bFactoriaDAO.getActasDAO().buscarDelegados(param);
			//sacamos el num que se ha metido
			int delegados=Integer.parseInt(escrutinio.getElectoresTotalColegioC1());
			int miles=trabajadoresTotales/1000;
			int delegadosTotal=delegados+(miles*2);
			escrutinio.setElectoresTotalColegioC1(String.valueOf(delegadosTotal));
			escrutinio.setElectoresTotalColegioC2(String.valueOf(delegadosTotal));
		}
		else{
			escrutinio= W83bFactoriaDAO.getActasDAO().buscarDelegados(param);
		}
		resultados.put("W83bDatosEscrutiniosBean", escrutinio);
		return resultados;	
	}
	public java.util.HashMap buscarTipoConvenio(w83b.w83bBeans.W83bActasBean param) throws Exception{
		HashMap resultados=new HashMap();
		W83bConveniosBean convenio= W83bFactoriaDAO.getActasDAO().buscarConvenio(param);
		resultados.put("W83bConveniosBean", convenio);
		return resultados;	
	}
	public java.util.List buscarPreavisos(w83b.w83bBeans.W83bActasBean param) throws Exception{
		
		
		List listaActas = W83bFactoriaDAO.getActasDAO().buscarPreavisos(param);
		listaActas.addAll(W83bFactoriaDAO.getActasDAO().buscarActaTotal(param));
		
		return listaActas;	
	}
	public java.util.List cargarCentroTrabajo(HashMap mapaResultado) throws Exception{
		List listaDatosParametros = W83bFactoriaDAO.getActasDAO().cargarCentroTrabajo(mapaResultado);
		
		return listaDatosParametros;
	}
	public String calcularNumActa(String actaEntrada,String anyoActa,String territorioActa)throws Exception{
		String resultado = "0";
		String acta = actaEntrada;
		
		if(StringUtils.isEmpty(acta)||StringUtils.isEmpty(anyoActa)||StringUtils.isEmpty(territorioActa)){
			acta = W83bFactoriaDAO.getActasDAO().maxCodActa(anyoActa, territorioActa);		
			if(W83bActasBD.maxNumActa.equals(acta)){
				boolean codEncontrado = false;
				if(Integer.parseInt(acta)+1
						!=Integer.parseInt(W83bFactoriaDAO.getActasDAO().contarActas(anyoActa, territorioActa))){
					while(!codEncontrado){
						acta = String.valueOf(Integer.parseInt(acta)-1);//NOPMD
						codEncontrado = !W83bFactoriaDAO.getActasDAO().existeActa(anyoActa, territorioActa, acta);
					}
					return acta;
				}else{
					resultado = "-1";
					return resultado;
				}
			}else{				
				acta = String.valueOf(Integer.parseInt(acta)+1);//NOPMD
				return acta;	
			}
		}else{
			boolean codEncontrado = W83bFactoriaDAO.getActasDAO().existeActa(anyoActa, territorioActa, acta);
			
			if(codEncontrado){
				acta = "-2";
			}
		}
		return acta;
	}
	public String anyadirActas(w83b.w83bBeans.W83bActasBean param,String pantalla) throws Exception{
		String idioma=param.getIdioma();
		String acta=param.getNumActa();
		String anyoActa=param.getNumActaAno();
		String territorioActa=param.getNumActaTerritorio();
		

		
		String versionActa=param.getVersion();
		String usuario=param.getUsuarioBean().getIdUsuario();
		param.setUsuario(usuario);
		if(StringUtils.isEmpty(param.getDelegadosMaximo()))
		{
			//buscamos el maximo de delgados
			int trabajadoresTotales=Integer.parseInt(param.getElectoresTotal());
			W83bActasBean actabusqueda=param;
			W83bDatosEscrutiniosBean escrutinio=new W83bDatosEscrutiniosBean();
			if(trabajadoresTotales>1001){
				actabusqueda.setTrabajadoresTotal("1000");
				escrutinio= W83bFactoriaDAO.getActasDAO().buscarDelegados(actabusqueda);
				//sacamos el num que se ha metido
				int delegados=Integer.parseInt(escrutinio.getElectoresTotalColegioC1());
				int miles=trabajadoresTotales/1000;
				int delegadosTotal=delegados+(miles*2);
				param.setDelegadosMaximo(String.valueOf(delegadosTotal));
			}
			else{
				actabusqueda.setTrabajadoresTotal(param.getElectoresTotal());
				escrutinio= W83bFactoriaDAO.getActasDAO().buscarDelegados(actabusqueda);
				param.setDelegadosMaximo(escrutinio.getElectoresTotalColegioC1());
			}
		}
		
		String resultado = "";
		if(!"incidencias".equals(pantalla)){
			resultado = calcularNumActa(acta,anyoActa,territorioActa);
			
			if("-1".equals(resultado)){
				return resultado;
			}else if("-2".equals(resultado)){
				return "-2";			
			}
		}else{
			resultado = acta;
		}
		
		param.setNumActa(resultado);
		acta = resultado;
		String fechaRegistro=W83bFactoriaDAO.getActasDAO().insertarActa(param,pantalla);//insertar acta
		if("incidencias".equals(pantalla)){
			W83bFactoriaDAO.getActasDAO().editarActaRegDef(param);
		}
		if(StringUtils.isNotEmpty(param.getNumPreaviso())&&StringUtils.isNotEmpty(param.getAnyoPreaviso())){
			W83bFactoriaDAO.getActasDAO().modificarPreaviso(param);//modificamos el preaviso
		}
		Collection c;
		Iterator itr;
		if(param.getPestanasModificadas().indexOf("Escrutinio")!=-1){
		
			HashMap escrutiniosc1=param.getDatosEscrutinio().getListaEscrutiniosC1();
			c=escrutiniosc1.values();
			itr=c.iterator();
			if(itr.hasNext()){
				while(itr.hasNext()){//insertar escrutinio1
					//insertar papeleteas
					W83bFactoriaDAO.getActasDAO().insertarEscrutinio((W83bListaEscrutiniosBean)itr.next(), acta, anyoActa, territorioActa, versionActa, usuario,idioma);
				}
			}
			W83bFactoriaDAO.getActasDAO().insertarPapeletas(param,param.getColegios().getCod1());
			HashMap escrutiniosc2=param.getDatosEscrutinio().getListaEscrutiniosC2();
			c=escrutiniosc2.values();
			itr=c.iterator();
			if(itr.hasNext()){
				while(itr.hasNext()){//insertar escrutinio2
					W83bFactoriaDAO.getActasDAO().insertarEscrutinio((W83bListaEscrutiniosBean)itr.next(), acta, anyoActa, territorioActa, versionActa, usuario,idioma);
				}
			}
			W83bFactoriaDAO.getActasDAO().insertarPapeletas(param,param.getColegios().getCod2());//insertar papeleteas
		}
		if(param.getPestanasModificadas().indexOf("Diferencia")!=-1){
			HashMap diferenciasc1=param.getDatosDiferencia().getListaDiferenciasC1();
			c=diferenciasc1.values();
			itr=c.iterator();
			while(itr.hasNext()){//insertar diferencia1
				W83bFactoriaDAO.getActasDAO().insertarDiferencia((W83bListaDiferenciasBean)itr.next(), acta, anyoActa, territorioActa, versionActa, usuario,idioma);
			}
			HashMap diferenciasc2=param.getDatosDiferencia().getListaDiferenciasC2();
			c=diferenciasc2.values();
			itr=c.iterator();
			while(itr.hasNext()){//insertar diferencia2
				W83bFactoriaDAO.getActasDAO().insertarDiferencia((W83bListaDiferenciasBean)itr.next(), acta, anyoActa, territorioActa, versionActa, usuario,idioma);
			}
		}
		if(param.getPestanasModificadas().indexOf("Delegado")!=-1){
			HashMap delegados=param.getListaDelegados();
			c=delegados.values();
			itr=c.iterator();
			while(itr.hasNext()){//insertar delegados
				W83bFactoriaDAO.getActasDAO().insertarDelegado((W83bListaDelegadosBean)itr.next(), acta, anyoActa, territorioActa, versionActa, usuario,idioma);
			}
		}
		//insertar los docs
		if(param.getPestanasModificadas().indexOf("Documento")!=-1){
			for (int i=0;i<param.getListaDocs().size();i++)
			{
				W83bDocBean doc=(W83bDocBean)param.getListaDocs().get(i);
				int id=Integer.parseInt(W83bFactoriaDAO.getActasDAO().maxCodDocAdjunto())+1;
				doc.setUsuarioBean(param.getUsuarioBean());
				doc.setId(String.valueOf(id));
				if("".equals(acta)){
					doc.setNumActa(resultado);
				}else{
					doc.setNumActa(acta);
				}
				doc.setNumActaAno(anyoActa);
				doc.setNumActaTerritorio(territorioActa);
				doc.setVersionActa(versionActa);
				String empresa = param.getRemitente();
				if(StringUtils.isEmpty(empresa)){
					empresa = param.getCentroTrabajo().getCifnif();
				}
				W83bFactoriaDAO.getActasDAO().insertarDocsActas(doc,idioma,empresa);
				
			}
		}
		if(StringUtils.isNotEmpty(fechaRegistro) 
				&&!"error".equals(fechaRegistro)){
			param.setFechaRegistroES(fechaRegistro);
		}
		if("actas".equals(pantalla)){
			W83bFactoriaDAO.getActasDAO().insertarHistorialActas(param,"comun.historial.insertacta");
			param.setFase(W83bClsConstantes.DOS+"");
			param.setTramite(W83bClsConstantes.UNO+"");
			W83bFactoriaDAO.getActasDAO().anyadirHistorialTramitacion(param,param.getFechaRegistroES());
			for (int i=0;i<param.getListaDocs().size();i++)
			{
				W83bDocBean doc=(W83bDocBean)param.getListaDocs().get(i);
				String[] tipos=doc.getTipoDocumento().split("_");
				param.setFase(tipos[1]);
				param.setTramite(tipos[2]);
				if(!W83bClsConstantes.TRAMITE_SINESPECIFICAR.equals(tipos[2])){
					if(!W83bFactoriaDAO.getActasDAO().buscarHistorialTramitacion(param.getUsuarioBean(), versionActa, param)){
						W83bFactoriaDAO.getActasDAO().anyadirHistorialTramitacion(param,param.getFechaRegistroES());
					}else{
						W83bFactoriaDAO.getActasDAO().editarHistorialTramitacion(param,param.getFechaRegistroES());				
					}
				}
			}
		}/*else if("incidencias".equals(pantalla)){	
			
			SimpleDateFormat hoy =new SimpleDateFormat(W83bClsConstantes.FORMATO_FECHA_CASTELLANO_PARSER);
//			W83bFactoriaDAO.getActasDAO().anyadirHistorialTramitacion(param,hoy.format(new Date()));
			if(!W83bFactoriaDAO.getActasDAO().buscarHistorialTramitacion(param.getUsuarioBean(), String.valueOf(Integer.parseInt(versionActa)-1), param)){
				W83bFactoriaDAO.getActasDAO().anyadirHistorialTramitacion(param,hoy.format(new Date()));
			}else{
				W83bFactoriaDAO.getActasDAO().anyadirHistorialTramitacionFechaModificacion(param,hoy.format(new Date()));				
			}
		}*/
		
		if(StringUtils.isNotEmpty(fechaRegistro) 
				&&"error".equals(fechaRegistro)){
			resultado = resultado.concat("||errorLibroReg");
		}
		
		
		return resultado;
	}
	public W83bColegiosBean cargarColegios() throws Exception{
		List listaDatosParametros = W83bFactoriaDAO.getActasDAO().cargarColegios();
		W83bColegiosBean colegios=new W83bColegiosBean();
		for(int i=0;i<listaDatosParametros.size();i++){
			if(i==0){
				colegios.setCod1(((BigDecimal)((HashMap)listaDatosParametros.get(i)).get(W83bColegiosBD.cod)).toString());
				colegios.setDescripcion1((String)((HashMap)listaDatosParametros.get(i)).get(W83bColegiosBD.descripcion));
				colegios.setDescripcion_eu1((String)((HashMap)listaDatosParametros.get(i)).get(W83bColegiosBD.descripcion_eu));
			}
			else{
				colegios.setCod2(((BigDecimal)((HashMap)listaDatosParametros.get(i)).get(W83bColegiosBD.cod)).toString());
				colegios.setDescripcion2((String)((HashMap)listaDatosParametros.get(i)).get(W83bColegiosBD.descripcion));
				colegios.setDescripcion_eu2((String)((HashMap)listaDatosParametros.get(i)).get(W83bColegiosBD.descripcion_eu));
			}
		}
		
		return colegios;
	}
	public W83bActasBean detalleActas(W83bActasBean param) throws Exception{
		
		String version = ""; 
		if(!"incidencias".equals(param.getPestana())){
			if(("fichaActaIncidencias").equals(param.getPestana())){
				version=param.getVersion();
			}else{
				List listaActas = W83bFactoriaDAO.getActasDAO().buscarActaMaxVersionValidada(param);
				version = ((HashMap)listaActas.get(0)).get(W83bActasBD.versionActa).toString();
			}
		}else{
			List listaActas = W83bFactoriaDAO.getActasDAO().buscarActaMaxVersionValidadaNoValidada(param);
			version = ((HashMap)listaActas.get(0)).get(W83bActasBD.versionActa).toString();			
		}
		
		
		param.setVersion(version);
		
		W83bActasBean acta=W83bFactoriaDAO.getActasDAO().detalleActas(param);
		W83bColegiosBean colegios = cargarColegios();
		
		param.setVersion(acta.getVersion());
		List papeletas=W83bFactoriaDAO.getActasDAO().buscarPapeletas(param);
		List delegados=W83bFactoriaDAO.getActasDAO().buscarDelegadosActa(param);//LOS DELEGADOS DE LA PESTAA DELEGADOS
		HashMap listaDelegados=new HashMap();
		if(!delegados.isEmpty()){
			for(int p=0;p<delegados.size();p++){
				W83bListaDelegadosBean delegado=(W83bListaDelegadosBean)delegados.get(p);
				listaDelegados.put(delegado.getDni(), delegado);
			}
		}
		acta.setListaDelegados(listaDelegados);
		acta.setListaEscrutinios(W83bFactoriaDAO.getActasDAO().buscarEscrutinioColegios(param));
		acta.setListaDiferencias(W83bFactoriaDAO.getActasDAO().buscarDiferenciaColegios(param));
		
	
		W83bDatosEscrutiniosBean escrutinio=new W83bDatosEscrutiniosBean();
		for(int i=0;i<papeletas.size();i++){
			W83bPapeletasBean papeleta=(W83bPapeletasBean)papeletas.get(i);
			if(papeleta.getColegio().equals("0"))
			{
				escrutinio.setPapeletasBlancasC1(papeleta.getBlancas());
				escrutinio.setPapeletasValidasC1(papeleta.getValidas());
				escrutinio.setPapeletasNulasC1(papeleta.getNulas());
				escrutinio.setElectoresTotalColegioC1(papeleta.getElectores());
				escrutinio.setVotantesTotalColegioC1(papeleta.getVotantes());
				escrutinio.setDelegadosTotalColegioC1(acta.getDatosEscrutinio().getDelegadosTotalColegioC1());
			}
			else
			{
				escrutinio.setPapeletasBlancasC2(papeleta.getBlancas());
				escrutinio.setPapeletasValidasC2(papeleta.getValidas());
				escrutinio.setPapeletasNulasC2(papeleta.getNulas());
				escrutinio.setElectoresTotalColegioC2(papeleta.getElectores());
				escrutinio.setVotantesTotalColegioC2(papeleta.getVotantes());
				escrutinio.setDelegadosTotalColegioC2(acta.getDatosEscrutinio().getDelegadosTotalColegioC2());
			}
			escrutinio.setDelegadosTotal(acta.getDatosEscrutinio().getDelegadosTotal());
			
		}
		acta.setDatosEscrutinio(escrutinio);
		acta.setColegios(colegios);
		if(StringUtils.isNotEmpty((String)acta.getBaja())){
			acta.setBaja(W83bClsConstantes.BAJA);
		}
		else{acta.setBaja(W83bClsConstantes.ALTA);}
		W83bFactoriaDAO.getActasDAO().insertarHistorialActas(param,"comun.historial.accesoacta");
		return acta;	
	}
	public java.util.List cargaTiposDocumentoActas(HashMap param) throws Exception {
		// TODO Auto-generated method stub
		return W83bFactoriaDAO.getActasDAO().cargaTiposDocumentoActas(param);
	}
	
	public W83bActasBean cargarListasActas(W83bActasBean param) throws Exception {
		// TODO Auto-generated method stub
		if(param.getPestana().equals("documentos")){
			
			if(StringUtils.isNotEmpty(param.getNumActa())){
				param.setListaDocs(W83bFactoriaDAO.getActasDAO().obtenerDocsActas(param));
			}
			return param;
		}
		else if(param.getPestana().equals("impugnaciones")){
			return W83bFactoriaDAO.getActasDAO().obtenerImpugnaciones(param);
		}
		else if(param.getPestana().equals("actasParciales")){
			
			param.setListaActasParciales(W83bFactoriaDAO.getActasDAO().obtenerActasParciales(param));
			return param;
		}
		else if(param.getPestana().equals("historial")){
			return W83bFactoriaDAO.getActasDAO().obtenerHistorialActa(param);
		}
		else if(param.getPestana().equals("tramitacion")){
			return W83bFactoriaDAO.getActasDAO().obtenerTramitesActas(param);
		}
		else if(param.getPestana().equals("incidencias")){
			return W83bFactoriaDAO.getActasDAO().obtenerIncidenciasActas(param);
		}
		else{
			return param;
		}
		
	}
	public W83bDocBean descargarDocumentoActas(String param) throws Exception {

		return W83bFactoriaDAO.getActasDAO().descargarDocumentoActas(param);
		
	}
	public String edicionActas(W83bActasBean param) throws Exception {
		W83bFactoriaDAO.getActasDAO().editarActa(param);
		//borramos los datos del acta del antiguo preaviso
		W83bFactoriaDAO.getActasDAO().borrarActaPreaviso(param.getNumActaTerritorio(),param.getNumActaAno(),param.getNumActa(),param.getUsuarioBean(),param.getIdioma());//borramos el acta del preaviso anterior
		
		if(StringUtils.isNotEmpty(param.getNumPreaviso())&&StringUtils.isNotEmpty(param.getAnyoPreaviso())){
			W83bFactoriaDAO.getActasDAO().modificarPreaviso(param);//modificamos el preaviso nuevo
		}
		String idioma=param.getIdioma();
		String acta=param.getNumActa();
		String anyoActa=param.getNumActaAno();
		String territorioActa=param.getNumActaTerritorio();
		String versionActa=param.getVersion();
		String usuario=param.getUsuarioBean().getIdUsuario();
		param.setUsuario(usuario);
		Collection c;
		Iterator itr;
		
		String errorLibroRegistro = "";
		
		//docs adjuntos
		if(param.getPestanasModificadas().indexOf("Documento")!=-1){
			for (int i=0;i<param.getListaDocs().size();i++)
			{
				W83bDocBean doc=(W83bDocBean)param.getListaDocs().get(i);
				int id=Integer.parseInt(W83bFactoriaDAO.getActasDAO().maxCodDocAdjunto())+1;
				doc.setUsuarioBean(param.getUsuarioBean());
				doc.setId(String.valueOf(id));
				doc.setNumActa(acta);
				doc.setNumActaAno(anyoActa);
				doc.setNumActaTerritorio(territorioActa);
				doc.setVersionActa(versionActa);
				String empresa = param.getRemitente();
				if(StringUtils.isEmpty(empresa)){
					empresa = param.getCentroTrabajo().getCifnif();
				}
				String error = W83bFactoriaDAO.getActasDAO().insertarDocsActas(doc,idioma,empresa);
				
				if("true".equals(error)){
					errorLibroRegistro = "-3";
				}
				
			}
			W83bFactoriaDAO.getActasDAO().borrarDocsActas(param);
		}
		if(param.getPestanasModificadas().indexOf("Escrutinio")!=-1){
			HashMap escrutiniosc1Borrados=param.getDatosEscrutinio().getListaEscrutiniosC1Borrados();
			c=escrutiniosc1Borrados.values();
			itr=c.iterator();
			while(itr.hasNext()){
				W83bListaEscrutiniosBean escrutinio=(W83bListaEscrutiniosBean)itr.next();
				//borramos el escrutinio
				W83bFactoriaDAO.getActasDAO().borrarEscrutinio(escrutinio);
			}
			HashMap escrutiniosc1=param.getDatosEscrutinio().getListaEscrutiniosC1();
			if(!escrutiniosc1.isEmpty()){
				c=escrutiniosc1.values();
				itr=c.iterator();
				while(itr.hasNext()){//insertar escrutinio1
					W83bListaEscrutiniosBean escrutinio=(W83bListaEscrutiniosBean)itr.next();
					if(W83bFactoriaDAO.getActasDAO().existeEscrutinio(escrutinio)){
						W83bFactoriaDAO.getActasDAO().modificarEscrutinio(escrutinio,usuario);
					}
					else{
						W83bFactoriaDAO.getActasDAO().insertarEscrutinio(escrutinio, acta, anyoActa, territorioActa, versionActa, usuario,idioma);
					}
				}
//				if(W83bFactoriaDAO.getActasDAO().existePapeletas(param,param.getColegios().getCod1())){
//					W83bFactoriaDAO.getActasDAO().modificarPapeletas(param,param.getColegios().getCod1());
//				}
//				else{
//					W83bFactoriaDAO.getActasDAO().insertarPapeletas(param,param.getColegios().getCod1());//insertar papeleteas
//				}
			}
//			else{
//				
//				W83bFactoriaDAO.getActasDAO().borrarPapeletasColegio(param,param.getColegios().getCod1());
//			}
			
//			W83bFactoriaDAO.getActasDAO().borrarPapeletasColegio(param,param.getColegios().getCod1());
			
//			if(StringUtils.isNotEmpty(param.getDatosEscrutinio().getPapeletasValidasC1())||
//					StringUtils.isNotEmpty(param.getDatosEscrutinio().getPapeletasNulasC1())||
//					StringUtils.isNotEmpty(param.getDatosEscrutinio().getPapeletasBlancasC1())||
//					StringUtils.isNotEmpty(param.getDatosEscrutinio().getElectoresTotalColegioC1())||
//					StringUtils.isNotEmpty(param.getDatosEscrutinio().getVotantesTotalColegioC1())){
				if(W83bFactoriaDAO.getActasDAO().existePapeletas(param,param.getColegios().getCod1())){
					W83bFactoriaDAO.getActasDAO().modificarPapeletas(param,param.getColegios().getCod1());
				}
				else{
					W83bFactoriaDAO.getActasDAO().insertarPapeletas(param,param.getColegios().getCod1());//insertar papeleteas
				}
//			}
			
			
			
			HashMap escrutiniosc2Borrados=param.getDatosEscrutinio().getListaEscrutiniosC2Borrados();
			c=escrutiniosc2Borrados.values();
			itr=c.iterator();
			while(itr.hasNext()){
				W83bListaEscrutiniosBean escrutinio=(W83bListaEscrutiniosBean)itr.next();
				W83bFactoriaDAO.getActasDAO().borrarEscrutinio(escrutinio);
				//borramos el escrutinio
			}
			HashMap escrutiniosc2=param.getDatosEscrutinio().getListaEscrutiniosC2();
			if(!escrutiniosc2.isEmpty()){
				c=escrutiniosc2.values();
				itr=c.iterator();
				while(itr.hasNext()){//insertar escrutinio2
					W83bListaEscrutiniosBean escrutinio=(W83bListaEscrutiniosBean)itr.next();
					if(W83bFactoriaDAO.getActasDAO().existeEscrutinio(escrutinio)){
						W83bFactoriaDAO.getActasDAO().modificarEscrutinio(escrutinio,usuario);
					}
					else{
						W83bFactoriaDAO.getActasDAO().insertarEscrutinio(escrutinio, acta, anyoActa, territorioActa, versionActa, usuario,idioma);
					}
				}
//				if(W83bFactoriaDAO.getActasDAO().existePapeletas(param,param.getColegios().getCod2())){
//					W83bFactoriaDAO.getActasDAO().modificarPapeletas(param,param.getColegios().getCod2());
//				}
//				else{
//					W83bFactoriaDAO.getActasDAO().insertarPapeletas(param,param.getColegios().getCod2());//insertar papeleteas
//				}
			}
//			else{
//				
//				W83bFactoriaDAO.getActasDAO().borrarPapeletasColegio(param,param.getColegios().getCod2());
//			}
			
			if(W83bFactoriaDAO.getActasDAO().existePapeletas(param,param.getColegios().getCod2())){
				W83bFactoriaDAO.getActasDAO().modificarPapeletas(param,param.getColegios().getCod2());
			}
			else{
				W83bFactoriaDAO.getActasDAO().insertarPapeletas(param,param.getColegios().getCod2());//insertar papeleteas
			}
			
			
		}
		if(param.getPestanasModificadas().indexOf("Diferencia")!=-1){
			HashMap diferenciasc1Borrados=param.getDatosDiferencia().getListaDiferenciasC1Borrados();
			c=diferenciasc1Borrados.values();
			itr=c.iterator();
			while(itr.hasNext()){
				W83bListaDiferenciasBean diferencia=(W83bListaDiferenciasBean)itr.next();
				//borramos la diferencia
				W83bFactoriaDAO.getActasDAO().borrarDiferencia(diferencia);
			}
			HashMap diferenciasc1=param.getDatosDiferencia().getListaDiferenciasC1();
			if(!diferenciasc1.isEmpty()){
				c=diferenciasc1.values();
				itr=c.iterator();
				while(itr.hasNext()){//insertar diferencia1
					W83bListaDiferenciasBean diferencia=(W83bListaDiferenciasBean)itr.next();
					if(W83bFactoriaDAO.getActasDAO().existeDiferencia(diferencia)){
						W83bFactoriaDAO.getActasDAO().modificarDiferencia(diferencia,usuario);
					}
					else{
						W83bFactoriaDAO.getActasDAO().insertarDiferencia(diferencia, acta, anyoActa, territorioActa, versionActa, usuario,idioma);
					}
				}
			}
		
			
			HashMap diferenciasc2Borrados=param.getDatosDiferencia().getListaDiferenciasC2Borrados();
			c=diferenciasc2Borrados.values();
			itr=c.iterator();
			while(itr.hasNext()){
				W83bListaDiferenciasBean diferencia=(W83bListaDiferenciasBean)itr.next();
				//borramos la diferencia
				W83bFactoriaDAO.getActasDAO().borrarDiferencia(diferencia);
			}
			HashMap diferenciasc2=param.getDatosDiferencia().getListaDiferenciasC2();
			if(!diferenciasc2.isEmpty()){
				c=diferenciasc2.values();
				itr=c.iterator();
				while(itr.hasNext()){//insertar diferencia2
					W83bListaDiferenciasBean diferencia=(W83bListaDiferenciasBean)itr.next();
					if(W83bFactoriaDAO.getActasDAO().existeDiferencia(diferencia)){
						W83bFactoriaDAO.getActasDAO().modificarDiferencia(diferencia,usuario);
					}
					else{
						W83bFactoriaDAO.getActasDAO().insertarDiferencia(diferencia, acta, anyoActa, territorioActa, versionActa, usuario,idioma);
					}
				}
			}
			
			
		}
		if(param.getPestanasModificadas().indexOf("eliminarDelegados")!=-1){
			W83bFactoriaDAO.getActasDAO().borrarFisicoDelegados(param);
		}
		if(param.getPestanasModificadas().indexOf("Delegado")!=-1){
			//los que estan en la pagina
			HashMap delegados=param.getListaDelegados();
			if(!delegados.isEmpty()){
				c=delegados.values();
				itr=c.iterator();
				//tenemos que mirar los que existen ahora mismo porque se pueden editar
				List delegadosexistentes=W83bFactoriaDAO.getActasDAO().buscarDelegadosActa(param);
				//20150602 controla que el listado no este vacio
				if (!delegadosexistentes.isEmpty()){
					W83bListaDelegadosBean delegadoExistente=(W83bListaDelegadosBean)delegadosexistentes.get(0);
					for(int d=0;d<delegadosexistentes.size();d++){
						delegadoExistente=(W83bListaDelegadosBean)delegadosexistentes.get(d);
						if(!delegados.containsKey(delegadoExistente.getDni())){
							W83bFactoriaDAO.getActasDAO().borrarDelegadoConcreto(param,delegadoExistente,param.getUsuarioBean());
						}
					}
				}
				while(itr.hasNext()){//insertar delegados
					W83bListaDelegadosBean delegado=(W83bListaDelegadosBean)itr.next();
					delegado.setUsuarioBean(param.getUsuarioBean());
					delegado.setIdioma(idioma);
					if(W83bFactoriaDAO.getActasDAO().existeListaDelegados(delegado)){
						W83bFactoriaDAO.getActasDAO().modificarDelegado(delegado,usuario);
					}
					else{
						W83bFactoriaDAO.getActasDAO().insertarDelegado(delegado, acta, anyoActa, territorioActa, versionActa, usuario,idioma);
					}
					
				}
			}
			else{
				//borramos los delegados
				W83bFactoriaDAO.getActasDAO().borrarDelegados(param);
				
			}
			
			
		}
		W83bFactoriaDAO.getActasDAO().insertarHistorialActas(param,"comun.historial.editacta");
			
		List mapaFiles =(List)param.getListaDocs();
		String [] mapaTramiteDoc =new String[4];
		
		Iterator iter = mapaFiles.iterator();
		while (iter.hasNext())
		{
			/*mapaTramiteDoc[0]=W83bClsConstantes.UNO+"";
			mapaTramiteDoc[1]=W83bClsConstantes.CONSTANTE_NO+"";
			mapaTramiteDoc[2]=W83bClsConstantes.CINCO+"";
			mapaTramiteDoc[3]=W83bClsConstantes.CONSTANTE_NO+"";
			W83bDocBean datosFile=(W83bDocBean)iter.next();
			String codActa=(String)datosFile.getTipoDocumento();
			String [] arrayActa = codActa.split("_");
			if(arrayActa[2].equals(W83bClsConstantes.CINCO+"")){
				mapaTramiteDoc[3]=W83bClsConstantes.CONSTANTE_SI+"";
			}else{
				mapaTramiteDoc[1]=W83bClsConstantes.CONSTANTE_SI+"";
			}
			if(mapaTramiteDoc[3].equals(W83bClsConstantes.CONSTANTE_SI+"")){*/
				W83bDocBean datosFile=(W83bDocBean)iter.next();
				String[] tipos=datosFile.getTipoDocumento().split("_");
				
				param.setFase(tipos[1]+"");
				param.setTramite(tipos[2]+"");
				if(!W83bClsConstantes.TRAMITE_SINESPECIFICAR.equals(tipos[2])){
					if(!W83bFactoriaDAO.getActasDAO().buscarHistorialTramitacion(param.getUsuarioBean(), versionActa, param)){
						W83bFactoriaDAO.getActasDAO().anyadirHistorialTramitacion(param,param.getFechaRegistroES());
					}else{
						W83bFactoriaDAO.getActasDAO().editarHistorialTramitacion(param,param.getFechaRegistroES());				
					}
				}
				
			/*}else{
				param.setFase(W83bClsConstantes.DOS+"");
				param.setTramite(W83bClsConstantes.UNO+"");
				
				W83bFactoriaDAO.getActasDAO().editarHistorialTramitacion(param,param.getFechaRegistroES());				
			}*/
		}
		
		return errorLibroRegistro;
	}
	
	public String borrarImpugnacionesActas(List paramImpugActa,W83bUsuarioXLNetsBean userBean ) throws Exception {
		boolean borrado = true;
		
		for(int i=0;i<paramImpugActa.size();i++){
			
			W83bImpugnacionBean bean = (W83bImpugnacionBean)paramImpugActa.get(i);
			
			String codImpug = bean.getTerritorioImpugnacion() 
									+ "_"+bean.getAnyoImpugnacion()
									+ "_"+bean.getNumImpugnacion()
							   +"__";
			borrado =  W83bFactoriaDAO.getImpugnacionesDAO().borrarSindicatos(codImpug,userBean);
			borrado =  W83bFactoriaDAO.getImpugnacionesDAO().borrarVoces(codImpug,userBean);
			borrado =  W83bFactoriaDAO.getImpugnacionesDAO().borrarDocsImpugnaciones(codImpug,userBean);
			borrado =  W83bFactoriaDAO.getImpugnacionesDAO().borrarLaudo(codImpug,userBean);
			borrado =  W83bFactoriaDAO.getImpugnacionesDAO().borrarEmpresaImpugnante(codImpug,userBean);
			borrado =  W83bFactoriaDAO.getImpugnacionesDAO().borrarHistorial(codImpug,userBean);
			borrado =  W83bFactoriaDAO.getImpugnacionesDAO().borrarTramitesImpugnacion(codImpug,userBean);
			borrado =  W83bFactoriaDAO.getImpugnacionesDAO().borrarImpugnacion(codImpug,userBean);
			
			
			if(!borrado){
				break;
			}
		}
		
		if (borrado)
			return "success";
		else 
			throw new Exception();
		
	}
	
	
	public String borrarActas(List param) throws Exception {
		W83bClsTrazas.trazaError(null, "borrandoActa -1",null);
		boolean borrado = true;
		
		boolean conVersion = true;
		
		W83bUsuarioXLNetsBean userBean = (W83bUsuarioXLNetsBean)param.get(param.size()-1);
		param.remove(param.size()-1);
		
			W83bActasBean acta = new W83bActasBean();
			acta.setCodTerritorioActa(((String)param.get(0)).split("_")[1]);
			acta.setNumActa(((String)param.get(0)).split("_")[1]+"/"+((String)param.get(0)).split("_")[2]+"/"+((String)param.get(0)).split("_")[3]);
		
			List incidencias = buscarIncidenciasActas(acta);
			if(null!=incidencias){
				if(0!=incidencias.size()){
					conVersion = false;
				}
				
				ArrayList listaIncidencias = new ArrayList();
				
				for(int i=0,size=incidencias.size();i<size;i++){
					W83bIncidenciasBean incidencia = new W83bIncidenciasBean();//NOPMD
					HashMap incidenciaMap = (HashMap)incidencias.get(i);
					
					
					incidencia.setTerritorioIncidencia(((String)param.get(0)).split("_")[1]);
					incidencia.setAnyoIncidencia(incidenciaMap.get(W83bIncidenciasBD.ANO_INCID_061).toString());
					incidencia.setNumIncidencia(incidenciaMap.get(W83bIncidenciasBD.N_INCID_061).toString());
					
					listaIncidencias.add(incidencia);
				}
				listaIncidencias.add(userBean);
				((W83bIIncidencias)(W83bIncidencias.class.newInstance())).borradoFisicoIncidenciasSoloIncidencias(listaIncidencias);
				
			}
		
			
			
//			borrado =  W83bFactoriaDAO.getIncidenciasDAO().borrarTablaIncidenciaPorActa(
//					((String)param.get(0)).split("_")[1],
//					((String)param.get(0)).split("_")[2],
//					((String)param.get(0)).split("_")[3],
//					userBean,
//					true);
//			borrado =  W83bFactoriaDAO.getIncidenciasDAO().borrarTablaIncidenciaPorActa(
//					((String)param.get(0)).split("_")[1],
//					((String)param.get(0)).split("_")[2],
//					((String)param.get(0)).split("_")[3],
//					userBean,
//					false);
			
			borrado =  W83bFactoriaDAO.getActasDAO().borrarEscrutinios((String)param.get(0),userBean,(String)param.get(1),conVersion);
			borrado =  W83bFactoriaDAO.getActasDAO().borrarDiferencias((String)param.get(0),userBean,(String)param.get(1),conVersion);
			borrado =  W83bFactoriaDAO.getActasDAO().borrarDelegados((String)param.get(0),userBean,(String)param.get(1),conVersion);
			
			String [] codActa=((String)param.get(0)).split("_");
			W83bImpugnacionBean bean = new W83bImpugnacionBean();
			bean.setNumActaTerritorioDesde(codActa[1]);
			bean.setNumActaTerritorioHasta(codActa[1]);
			bean.setNumActaAnyoDesde(codActa[2]);
			bean.setNumActaAnyoHasta(codActa[2]);
			bean.setNumActaNumeroDesde(codActa[3]);
			bean.setNumActaNumeroHasta(codActa[3]);
			bean.setUsuarioBean(userBean);
			bean.setIdioma(userBean.getIdioma());
			List result = W83bFactoriaDAO.getImpugnacionesDAO().buscarImpugnaciones(bean);
			if(null!=result&&result.size()>0){
//				borrado =  W83bFactoriaDAO.getActasDAO().borrarHistorialImpugnaciones((String)param.get(0),userBean);				
//				borrado =  W83bFactoriaDAO.getActasDAO().borrarAuditoriaImpugnaciones((String)param.get(0),userBean);
				
				borrarImpugnacionesActas(result,userBean);
			}
//			borrado =  W83bFactoriaDAO.getActasDAO().borrarImpugnaciones((String)param.get(0),userBean,(String)param.get(1));
			borrado =  W83bFactoriaDAO.getActasDAO().borrarPapeletas((String)param.get(0),userBean,(String)param.get(1),conVersion);
			borrado =  W83bFactoriaDAO.getActasDAO().borrarDocsAdjuntos((String)param.get(0),userBean,(String)param.get(1),conVersion);
			borrado =  W83bFactoriaDAO.getActasDAO().borrarHistorialTramitacion((String)param.get(0),userBean,(String)param.get(1),conVersion);
			borrado =  W83bFactoriaDAO.getActasDAO().borrarHistorialActa((String)param.get(0),userBean);
			borrado =  W83bFactoriaDAO.getActasDAO().borrarActaFisico((String)param.get(0),userBean,(String)param.get(1),conVersion);
			
			W83bFactoriaDAO.getActasDAO().borrarActaPreaviso(codActa[1],codActa[2],codActa[3],userBean,userBean.getIdioma());//borramos el acta del preaviso anterior
			
		if (borrado)
			return "success";
		else 
			return "error";
	}
	
	public String borrarActasSinIncidencias(List param) throws Exception {
		W83bClsTrazas.trazaError(null, "borrandoActa -1",null);
		boolean borrado = true;
		
		W83bUsuarioXLNetsBean userBean = (W83bUsuarioXLNetsBean)param.get(param.size()-1);
		param.remove(param.size()-1);
		
		
			borrado =  W83bFactoriaDAO.getActasDAO().borrarEscrutinios((String)param.get(0),userBean,(String)param.get(1),true);
			borrado =  W83bFactoriaDAO.getActasDAO().borrarDiferencias((String)param.get(0),userBean,(String)param.get(1),true);
			borrado =  W83bFactoriaDAO.getActasDAO().borrarDelegados((String)param.get(0),userBean,(String)param.get(1),true);
			
			String [] codActa=((String)param.get(0)).split("_");
			W83bImpugnacionBean bean = new W83bImpugnacionBean();
			bean.setNumActaTerritorioDesde(codActa[1]);
			bean.setNumActaTerritorioHasta(codActa[1]);
			bean.setNumActaAnyoDesde(codActa[2]);
			bean.setNumActaAnyoHasta(codActa[2]);
			bean.setNumActaNumeroDesde(codActa[3]);
			bean.setNumActaNumeroHasta(codActa[3]);
			bean.setUsuarioBean(userBean);
			bean.setIdioma(userBean.getIdioma());
			/*List result = W83bFactoriaDAO.getImpugnacionesDAO().buscarImpugnaciones(bean);
			if(null!=result&&result.size()>0){
//				borrado =  W83bFactoriaDAO.getActasDAO().borrarHistorialImpugnaciones((String)param.get(0),userBean);				
//				borrado =  W83bFactoriaDAO.getActasDAO().borrarAuditoriaImpugnaciones((String)param.get(0),userBean);
				
				//borrarImpugnacionesActas(result,userBean);
				//FALLO BORRAR INCIDENCIA, SE BORRABA LA INCIDENCIA PERO NO EL ACTA PQ TENIA UNA IMPUGNACIN CON VERSIN SUPERIOR
				
				int versionImpug=Integer.parseInt(((W83bImpugnacionBean)result.get(0)).getVersionActa());
				int versionActa=Integer.parseInt((String)param.get(1));
				if (versionImpug>0){
					W83bIncidenciaImpugnacionBean impug = new W83bIncidenciaImpugnacionBean();
					impug.setIdioma("");
					impug.setUsuarioBean(userBean);
					versionActa=versionActa-1;
					impug.setVersion(String.valueOf(versionActa));
					impug.setAnoActa(codActa[2]);
					impug.setNActa(codActa[3]);
					impug.setCodTerritorioImpugnacion(codActa[1]);
					W83bFactoriaDAO.getIncidenciasDAO().actualizarImpugnacionIncidencia(impug);
				}
			}*/
//			borrado =  W83bFactoriaDAO.getActasDAO().borrarImpugnaciones((String)param.get(0),userBean,(String)param.get(1));
			borrado =  W83bFactoriaDAO.getActasDAO().borrarPapeletas((String)param.get(0),userBean,(String)param.get(1),true);
			borrado =  W83bFactoriaDAO.getActasDAO().borrarDocsAdjuntos((String)param.get(0),userBean,(String)param.get(1),true);
			borrado =  W83bFactoriaDAO.getActasDAO().borrarHistorialTramitacion((String)param.get(0),userBean,(String)param.get(1),true);
			//borrado =  W83bFactoriaDAO.getActasDAO().borrarHistorialActa((String)param.get(0),userBean);
			borrado =  W83bFactoriaDAO.getActasDAO().borrarActaFisico((String)param.get(0),userBean,(String)param.get(1),true);
			
			//W83bFactoriaDAO.getActasDAO().borrarActaPreaviso(codActa[1],codActa[2],codActa[3],userBean,userBean.getIdioma());//borramos el acta del preaviso anterior
			
		if (borrado)
			return "success";
		else 
			return "error";
	}
	
	public String borrarActasLogica(List param) throws Exception {
		boolean borrado = true;
		
		W83bUsuarioXLNetsBean userBean = (W83bUsuarioXLNetsBean)param.get(param.size()-1);
		String idioma=(String)param.get(param.size()-2);
		String version=(String)param.get(param.size()-3);
		String fecha=(String)param.get(param.size()-4);
		String motivo=(String)param.get(param.size()-5);
		
		borrado=W83bFactoriaDAO.getActasDAO().borrarActaLogico((String)param.get(0),motivo,fecha,userBean,idioma,version);
		String[] codActa=((String)param.get(0)).split("_");
		W83bActasBean actaBorrar=new W83bActasBean();
		actaBorrar.setNumActa(codActa[3]);
		actaBorrar.setNumActaAno(codActa[2]);
		actaBorrar.setNumActaTerritorio(codActa[1]);
		actaBorrar.setUsuarioBean(userBean);
		W83bFactoriaDAO.getActasDAO().insertarHistorialActas(actaBorrar,"comun.historial.deleteacta");
		//descartamos las incidencias que estan no validadas
		W83bFactoriaDAO.getActasDAO().descartarIncidenciaActa((String)param.get(0), userBean, idioma, version);
		if (borrado)
			return "success";
		else 
			return "error";
	}
	public List buscarListaSindicatos(w83b.w83bBeans.W83bActasBean param) throws Exception{
		
		return W83bFactoriaDAO.getActasDAO().buscarSindicatosActas(param);
			
	}
	public java.util.List buscarCentroTrabajo(w83b.w83bBeans.W83bCentroTrabajoBean param) throws Exception{
		List listaCentroTrabajo=new ArrayList();
		try{
			listaCentroTrabajo = W83bFactoriaDAO.getMantenimientosDAO().buscarCentroTrabajo(param);
			if(!listaCentroTrabajo.isEmpty()&&listaCentroTrabajo.size()==1){
				param.setCodCentroTrabajo(((W83bCentroTrabajoBean)listaCentroTrabajo.get(0)).getCodCentroTrabajo());
//				String numActa=W83bFactoriaDAO.getActasDAO().buscarActaPorCentroTrabajo(param);
//				((W83bCentroTrabajoBean)listaCentroTrabajo.get(0)).setActa(numActa);
			}
		}
		catch (Exception e){
			W83bClsTrazas.trazaError(null, "Errorbuscarcentrotrabajo",null);
			throw e;
		}
		
		return listaCentroTrabajo;	
	}
	public List buscarImpugnacionActas(w83b.w83bBeans.W83bActasBean param) throws Exception{
		
		return W83bFactoriaDAO.getActasDAO().buscarImpugnacion(param);
		
	}
	public List buscarIncidenciasActas(w83b.w83bBeans.W83bActasBean param) throws Exception{
		
		return W83bFactoriaDAO.getActasDAO().buscarIncidencias(param);
		
	}
	public List buscarPreavisosdeCentroTrabajo(w83b.w83bBeans.W83bCentroTrabajoBean param) throws Exception{
		
		return W83bFactoriaDAO.getActasDAO().buscarPreavisosdeCentroTrabajo(param);
		
	}
	
	
	public java.util.List validarIntervaloEleccionSindicalCtoTrabajo (java.util.HashMap param) throws Exception{
		// TODO Auto-generated method stub
		
		List resultado = new ArrayList();
		
		resultado = W83bFactoriaDAO.getActasDAO().validarIntervaloEleccionSindicalCtoTrabajo(
				(String)param.get("idCentroTrabajo"),(String)param.get("idioma"),
				(String)param.get("territorioActa"),(String)param.get("anyoActa"),(String)param.get("nActa"));
		
		if(null!=resultado 
				&&0<resultado.size()
				&&StringUtils.isNotEmpty((String)resultado.get(0))){
			String fechaEntradaQuery = (String)resultado.get(0);
			String fechaEntrada = (String)param.get("fecha_entrada");
			
			Date fechaEntradaQueryDate = W83bDateUtil.getInstance().getDate(fechaEntradaQuery,W83bDateUtil.getInstance().devolverFormatoIdioma((String)param.get("idioma")));
			Date fechaEntradaDate = W83bDateUtil.getInstance().getDate(fechaEntrada,W83bDateUtil.getInstance().devolverFormatoIdioma((String)param.get("idioma")));
			
			fechaEntradaQueryDate = W83bDateUtil.getInstance().addYears(fechaEntradaQueryDate,4);
			fechaEntradaDate = W83bDateUtil.getInstance().addMonths(fechaEntradaDate,3);
			
			resultado = new ArrayList();
			if(fechaEntradaDate.compareTo(fechaEntradaQueryDate)>=0){
				resultado.add("true");				
			}else{
				resultado.add("false");				
			}
			
		}else{
			resultado = new ArrayList();
			resultado.add("true");
		}
		
		return resultado;
	}
	
	public String buscarFechaCierre (java.util.HashMap param) throws Exception{
		// TODO Auto-generated method stub
		
		return W83bFactoriaDAO.getActasDAO().buscarFechaCierre(param);
	}
	
	//David sept.2013
	public java.util.HashMap validarFechaActas(ArrayList listActa)throws Exception{
		HashMap listaactas=new HashMap();
		List listaActasDef=new ArrayList();
		List actasNoValid = new ArrayList();
		
		W83bUsuarioXLNetsBean userBean = (W83bUsuarioXLNetsBean)listActa.get(listActa.size()-1);
		listActa.remove(listActa.size()-1);		
		boolean blnActaCorrecta;
		boolean blnActaConIncidencias;
		
		for(int i = 0,size=listActa.size();i<size;i++){
			blnActaCorrecta=false;
			blnActaConIncidencias=false;
			W83bActasBean acta = (W83bActasBean)listActa.get(i);//NOPMD
			W83bActasBean actaTemp = new W83bActasBean();//NOPMD
			//acta.setUsuarioBean(userBean);
			//System.out.println("Validando.... "+acta.getNumActaTerritorio()+"/"+acta.getNumActaAno()+"/"+acta.getNumActa());
		    		
            //Comprobar si el act tiene incidencias asignadas 		
			List incidencias = buscarIncidenciasActas(acta);
			if(null!=incidencias){
				if(0!=incidencias.size()){
					blnActaConIncidencias = true;
				}
			}	
			
			//Comprobar que la fecha de eleccin no sea posterior a la de Comisin
			java.util.Date dateComision= W83bDateUtil.getInstance().stringToDateIdioma(acta.getFechaComision(),acta.getIdioma());
			java.util.Date dateEleccion= W83bDateUtil.getInstance().stringToDateIdioma(acta.getFechaEleccion(),acta.getIdioma());
			//Comprobar que no est de baja
			boolean blnEsBaja=W83bFactoriaDAO.getActasDAO().blnActaBaja(acta);
			
			if (!blnActaConIncidencias){
				if (!blnEsBaja){
					if(StringUtils.isEmpty(acta.getNumRegDefinitivo())){
						if(StringUtils.isEmpty(acta.getFechaBaja())){
							if(null!=dateEleccion && dateEleccion.before(dateComision)){
								blnActaCorrecta=true;
							}
						}
					}
				}
			}	
			if (blnActaCorrecta){
				 //Si estn todas las validaciones OK, se hace update y se mete en la lista de Validadas OK 	
				actaTemp.setIdioma(acta.getIdioma());
				actaTemp.setUsuarioBean(userBean);
				actaTemp.setNumActa(acta.getNumActa());
				actaTemp.setNumActaAno(acta.getNumActaAno());
				actaTemp.setFechaComision(acta.getFechaComision());
				actaTemp.setVersion(acta.getVersion());
				actaTemp.setNumActaTerritorio(acta.getNumActaTerritorio());			
				W83bFactoriaDAO.getActasDAO().editarActaFechaComision(actaTemp);
				listaActasDef.add(acta.getNumActa());					
			}else{
				actasNoValid.add(acta.getNumActa());
			}
		}
		
		
		listaactas.put("actasvivas", actasNoValid);
		listaactas.put("listaActas", listaActasDef);
		return listaactas;
	}
	
	
	/**
    * Actualiza la informacin de acuse de recibo de una lista de comunicaciones de actas
    * @param listaComunicacionesAcuse List
    * @throws Exception the exception
    */
	public void actualizarDatosAcusesComunicacionActas (ArrayList listaComunicacionesAcuse)throws Exception{
		//Recorremos las comunicaciones
		for (Iterator iter = listaComunicacionesAcuse.iterator(); iter.hasNext();) {
			W83bDocBean docBean = (W83bDocBean) iter.next();
			docBean.setCodTramite("3");
			docBean.setCodFase("2");
			W83bFactoriaDAO.getActasDAO().actualizarDatosAcuseComunicacion(docBean);
		}
	}
	
	
	/**
	* Actualiza la informacin de acuse de recibo de una comunicacin  de requerimientos de mesa de acta
    * @param listaComunicacionesAcuse List
    * @throws Exception the exception
    */
	public void  actualizarDatosAcusesComunicacionActasRequMesa(ArrayList listaComunicacionesAcuse)throws Exception{
		//Recorremos las comunicaciones
		for (Iterator iter = listaComunicacionesAcuse.iterator(); iter.hasNext();) {
			W83bDocBean docBean = (W83bDocBean) iter.next();
			docBean.setCodTramite("4");
			docBean.setCodFase("2");
			W83bFactoriaDAO.getActasDAO().actualizarDatosAcuseComunicacion(docBean);
		}
	}
}